/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.PlayerComponent;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EquipmentChangeWatcher
implements EntityComponentInitializer {
    private static final class_2960 ID = TConstruct.getResource("equipment_watcher");
    public static final ComponentKey<PlayerLastEquipment> CAPABILITY = ComponentRegistry.getOrCreate((class_2960)ID, PlayerLastEquipment.class);

    public static void register() {
        ServerEntityEvents.EQUIPMENT_CHANGE.register(EquipmentChangeWatcher::onEquipmentChange);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            PlayerTickEvents.END.register(EquipmentChangeWatcher::onPlayerTick);
        }
    }

    private static void onEquipmentChange(class_1309 entity, class_1304 slot, @Nonnull class_1799 from, @Nonnull class_1799 to) {
        EquipmentChangeWatcher.runModifierHooks(entity, slot, from, to);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(CAPABILITY, PlayerLastEquipment::new);
        EntityEvents.ON_REMOVE.register((entity, reason) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                ((PlayerLastEquipment)CAPABILITY.get((Object)player)).run();
            }
        });
    }

    private static void onPlayerTick(class_1657 player) {
        CAPABILITY.maybeGet((Object)player).ifPresent(PlayerLastEquipment::update);
    }

    private static void runModifierHooks(class_1309 entity, class_1304 changedSlot, class_1799 original, class_1799 replacement) {
        EquipmentChangeContext context = new EquipmentChangeContext(entity, changedSlot, original, replacement);
        IToolStackView tool = context.getOriginalTool();
        if (tool != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.EQUIPMENT_CHANGE).onUnequip(tool, entry, context);
            }
            if (!entity.method_6115() || entity.method_6118(changedSlot) != entity.method_6030()) {
                ModifierUtil.finishUsingItem(tool);
            }
        }
        if ((tool = context.getReplacementTool()) != null) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.EQUIPMENT_CHANGE).onEquip(tool, entry, context);
            }
        }
        for (class_1304 otherSlot : class_1304.values()) {
            if (otherSlot == changedSlot || (tool = context.getToolInSlot(otherSlot)) == null) continue;
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.EQUIPMENT_CHANGE).onEquipmentChange(tool, entry, context, otherSlot);
            }
        }
        new ToolEquipmentChangeEvent(context).sendEvent();
    }

    protected static class PlayerLastEquipment
    implements PlayerComponent<PlayerLastEquipment>,
    Runnable {
        @Nullable
        private final class_1657 player;
        private final Map<class_1304, class_1799> lastItems = new EnumMap<class_1304, class_1799>(class_1304.class);
        private LazyOptional<PlayerLastEquipment> capability;

        private PlayerLastEquipment(@Nullable class_1657 player) {
            this.player = player;
            for (class_1304 slot : class_1304.values()) {
                this.lastItems.put(slot, class_1799.field_8037);
            }
            this.capability = LazyOptional.of(() -> this);
        }

        public void update() {
            if (this.player != null) {
                for (class_1304 slot : class_1304.values()) {
                    class_1799 newStack = this.player.method_6118(slot);
                    class_1799 oldStack = this.lastItems.get(slot);
                    if (class_1799.method_7973((class_1799)oldStack, (class_1799)newStack)) continue;
                    this.lastItems.put(slot, newStack.method_7972());
                    EquipmentChangeWatcher.runModifierHooks((class_1309)this.player, slot, oldStack, newStack);
                }
            }
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> this);
        }

        public void readFromNbt(class_2487 tag) {
        }

        public void writeToNbt(class_2487 tag) {
        }
    }
}

